package com.example.sefinsa_app.ui.rmd.Crear;

import static androidx.core.location.LocationManagerCompat.getCurrentLocation;
import static com.example.sefinsa_app.utilities.BluetoothUtils.context;
import static com.example.sefinsa_app.utilities.BluetoothUtils.mConnectedThread;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ProgressDialog;
import android.bluetooth.BluetoothAdapter;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.location.Location;
import android.location.LocationManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.Fragment;
import androidx.navigation.Navigation;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import android.os.Looper;
import android.provider.MediaStore;
import android.provider.Settings;
import android.text.InputFilter;
import android.util.Base64;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import com.example.sefinsa_app.DashboardActivity;
import com.example.sefinsa_app.R;
import com.example.sefinsa_app.controllers.RMDController;
import com.example.sefinsa_app.models.Articulo;
import com.example.sefinsa_app.models.RMD;
import com.example.sefinsa_app.ui.folios.crear.DibujarFirmaActivity;
import com.example.sefinsa_app.utilities.BluetoothUtils;
import com.example.sefinsa_app.utilities.NetworkChange;
import com.example.sefinsa_app.utilities.Validator;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.material.datepicker.CalendarConstraints;
import com.google.android.material.datepicker.MaterialDatePicker;
import com.google.android.material.datepicker.MaterialPickerOnPositiveButtonClickListener;
import com.google.android.material.textfield.TextInputEditText;
import com.google.android.material.textfield.TextInputLayout;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

/**
 * A simple {@link Fragment} subclass.
 * Use the {@link CrearRMDFragment#newInstance} factory method to
 * create an instance of this fragment.
 */
public class CrearRMDFragment extends Fragment {
    private static final String ARG_PARAM1 = "param1";
    private static final String ARG_PARAM2 = "param2";

    private String mParam1;
    private String mParam2;

    public CrearRMDFragment() { }

    public static CrearRMDFragment newInstance(String param1, String param2) {
        CrearRMDFragment fragment = new CrearRMDFragment();
        Bundle args = new Bundle();
        args.putString(ARG_PARAM1, param1);
        args.putString(ARG_PARAM2, param2);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (getArguments() != null) {
            mParam1 = getArguments().getString(ARG_PARAM1);
            mParam2 = getArguments().getString(ARG_PARAM2);
        }
    }

    // Variables para los inputs

    TextInputLayout
            tlFolio,
            tlNumeroCuenta,
            tlNombre,
            tlTelefono,
            tlRuta,
            tlPoblacion,
            tlFecha,
            tlValorGarantia,
            tlPagara,
            tlFechaIns,
            tlRecibeMercancia;

    TextInputEditText
            edTxtFolio,
            edTxtNumeroCuenta,
            edTxtNombre,
            edTxtRuta,
            edTxtTelefono,
            edTxtPoblacion,
            edTxtFecha,
            edTxtValorGarantia,
            edTxtPagara,
            edTxtFechaIns,
            edTxtRecibeMercancia;

    Button
            btnAgregarArticulo,
            btnInsertarFirmaCliente,
            btnInsertarFirmaAsesor,
            btnAgregarRMD;

    ImageView
            imgVwFirmaCliente,
            imgVwFirmaAsesor;

    String
            lat = "",
            lgt = "";

    FusedLocationProviderClient client;

    // Variable para id de prestamo

    String prestamoID;

    // Controllers

    RMDController rmdController;

    // Shared preferences

    SharedPreferences sesion;

    // Otras variables

    ArrayList<Articulo> articulosAgregados;
    RecyclerView rvArticulos;
    String
            firmaCliente,
            firmaAsesor;
    ImageView
            imgFirmaCliente,
            imgFirmaAsesor;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_crear_r_m_d, container, false);

        Bundle bundle = getArguments();
        if (bundle != null) { prestamoID = bundle.getString("prestamoId"); }

        setVars(view);
        setControllers();
        setInputVars(view);
        setInputVals();
        setOnClickListeners();

        return view;
    }

    @Override
    public void onResume() {
        super.onResume();

        SharedPreferences p = requireActivity().getSharedPreferences("firmas", Context.MODE_PRIVATE);

        firmaCliente = p.getString("firmaClienteRMD", null);
        if (firmaCliente != null) {
            byte[] decodedBytes = Base64.decode(firmaCliente, Base64.DEFAULT);
            Bitmap bitmap = BitmapFactory.decodeByteArray(decodedBytes, 0, decodedBytes.length);
            imgFirmaCliente.setImageBitmap(bitmap);
        }

        firmaAsesor = p.getString("firmaAsesorRMD", null);
        if (firmaAsesor != null) {
            byte[] decodedBytes = Base64.decode(firmaAsesor, Base64.DEFAULT);
            Bitmap bitmap = BitmapFactory.decodeByteArray(decodedBytes, 0, decodedBytes.length);
            imgFirmaAsesor.setImageBitmap(bitmap);
        }
    }

    public void setControllers() {
        rmdController = new RMDController(getContext(), getActivity());
    }

    public void setInputVars(View view) {
        tlFolio = view.findViewById(R.id.tlFolio);
        tlNumeroCuenta = view.findViewById(R.id.tlNumeroCuenta);
        tlNombre = view.findViewById(R.id.tlNombre);
        tlTelefono = view.findViewById(R.id.tlTelefono);
        tlRuta = view.findViewById(R.id.tlRuta);
        tlPoblacion = view.findViewById(R.id.tlPoblacion);
        tlFecha = view.findViewById(R.id.tlFecha);
        tlValorGarantia = view.findViewById(R.id.tlValorGarantia);
        tlPagara = view.findViewById(R.id.tlPagara);
        tlFechaIns = view.findViewById(R.id.tlFechaIns);
        tlRecibeMercancia = view.findViewById(R.id.tlRecibeMercancia);

        edTxtFolio = view.findViewById(R.id.etFolio);
        edTxtNumeroCuenta = view.findViewById(R.id.etNumeroCuenta);
        edTxtNombre = view.findViewById(R.id.etNombre);
        edTxtRuta = view.findViewById(R.id.etRuta);
        edTxtTelefono = view.findViewById(R.id.etTelefono);
        edTxtPoblacion = view.findViewById(R.id.etPoblacion);
        edTxtFecha = view.findViewById(R.id.etFecha);

        edTxtValorGarantia = view.findViewById(R.id.etValorGarantia);
        edTxtPagara = view.findViewById(R.id.etPagara);

        InputFilter[] filter = new InputFilter[]{ new DecimalDigitsInputFilter(8, 2) };

        edTxtValorGarantia.setFilters(filter);
        edTxtPagara.setFilters(filter);

        edTxtFechaIns = view.findViewById(R.id.etFechaIns);
        edTxtRecibeMercancia = view.findViewById(R.id.etRecibeMercancia);

        btnAgregarArticulo = view.findViewById(R.id.btnAgregarArticulo);
        btnInsertarFirmaCliente = view.findViewById(R.id.btnFirmaCliente);
        btnInsertarFirmaAsesor = view.findViewById(R.id.btnFirmaAsesor);
        btnAgregarRMD = view.findViewById(R.id.btnAgregarRMD);

        imgVwFirmaCliente = view.findViewById(R.id.imgFirmaCliente);
        imgVwFirmaAsesor = view.findViewById(R.id.imgFirmaAsesor);
    }

    public void setInputVals() {
        RMD rmd = rmdController.getDatosBaseRMD(prestamoID);

        sesion = getContext().getSharedPreferences("sesion", Context.MODE_PRIVATE);
        String empleado_id = sesion.getString("id", null);

        edTxtFolio.setText(rmdController.getPrimerRMDId(empleado_id));

        edTxtNumeroCuenta.setText(rmd.getNumeroCuenta());
        edTxtNombre.setText(rmd.getNombre());
        edTxtTelefono.setText(rmd.getTelefono());
        edTxtRuta.setText(rmd.getRuta());
        edTxtPoblacion.setText(rmd.getPoblacion());

        LocalDate today = null;
        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.O) {
            today = LocalDate.now();

            String[] pFecha = String.valueOf(today).split("-");
            tlFecha.getEditText().setText(pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0]);
        }
    }

    public void setVars(View view) {
        articulosAgregados = new ArrayList<Articulo>();
        rvArticulos = view.findViewById(R.id.rvArticulos);
        imgFirmaCliente = view.findViewById(R.id.imgFirmaCliente);
        imgFirmaAsesor = view.findViewById(R.id.imgFirmaAsesor);

        SharedPreferences p = requireActivity().getSharedPreferences("firmas", Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = p.edit();

        editor.remove("firmaClienteRMD");
        editor.remove("firmaAsesorRMD");
        editor.apply();
    }

    public void setOnClickListeners() {
        btnAgregarArticulo.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View vw) {
                getCurrentLocation();
                if (articulosAgregados.size() == 3) {
                    AlertDialog.Builder builder = new AlertDialog.Builder(requireActivity());
                    builder.setTitle("Cantidad de artículos maxima alcanzada");
                    builder.setMessage("No se pueden agregar mas de tres articulos.");

                    builder.setPositiveButton("Aceptar", new DialogInterface.OnClickListener() {
                        public void onClick(DialogInterface dialog, int id) {
                            dialog.dismiss();
                        }
                    });

                    AlertDialog dialog = builder.create();
                    dialog.show();
                } else {
                    AlertDialog.Builder builder = new AlertDialog.Builder(getContext());
                    View dialogLayout = LayoutInflater.from(getContext()).inflate(R.layout.formulario_agregar_articulo_rmd, null);
                    builder.setView(dialogLayout);

                    TextInputEditText edTxtArticulo = dialogLayout.findViewById(R.id.etArticulo);
                    TextInputEditText edTxtMarca = dialogLayout.findViewById(R.id.etMarca);
                    TextInputEditText edTxtColor = dialogLayout.findViewById(R.id.etColor);
                    TextInputEditText edTxtCondiciones = dialogLayout.findViewById(R.id.etDetallarCondiciones);

                    builder.setTitle("Agregar artículo");

                    builder.setPositiveButton("Agregar", null);
                    builder.setNegativeButton("Cancelar", (dialogInterface, i) -> dialogInterface.dismiss());

                    AlertDialog dialog = builder.create();

                    dialog.setOnShowListener(d -> {
                        Button btnAgregar = dialog.getButton(AlertDialog.BUTTON_POSITIVE);
                        btnAgregar.setOnClickListener(v -> {
                            String articulo = edTxtArticulo.getText().toString().trim();
                            String marca = edTxtMarca.getText().toString().trim();
                            String color = edTxtColor.getText().toString().trim();
                            String condiciones = edTxtCondiciones.getText().toString().trim();
                            ArrayList<Bitmap> imagenes = new ArrayList<>();
                            ArrayList<Uri> urisImagenes = new ArrayList<>();

                            if (articulo.isEmpty() || marca.isEmpty() || color.isEmpty() || condiciones.isEmpty()) {
                                Toast.makeText(getContext(), "Todos los campos son requeridos", Toast.LENGTH_SHORT).show();
                            } else {
                                articulosAgregados.add(new Articulo(articulo, marca, color, condiciones, imagenes, urisImagenes));
                                setArticulosRecyclerView();
                                Toast.makeText(getContext(), "Artículo agregado", Toast.LENGTH_SHORT).show();
                                dialog.dismiss();
                            }
                        });
                    });

                    dialog.show();

                }
            }
        });

        btnInsertarFirmaCliente.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(getActivity(), DibujarFirmaActivity.class);
                intent.putExtra("titulo", "Dibujar firma de cliente");
                startActivity(intent);
            }
        });

        btnInsertarFirmaAsesor.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(getActivity(), DibujarFirmaActivity.class);
                intent.putExtra("titulo", "Dibujar firma de asesor");
                startActivity(intent);
            }
        });

        tlFechaIns.getEditText().setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                MaterialDatePicker.Builder<Long> materialDateBuilder = MaterialDatePicker.Builder.datePicker();
                materialDateBuilder.setTitleText("Fecha");

                CalendarConstraints.Builder constraintsBuilder = new CalendarConstraints.Builder();
                constraintsBuilder.setEnd(MaterialDatePicker.todayInUtcMilliseconds());

                materialDateBuilder.setCalendarConstraints(constraintsBuilder.build());

                MaterialDatePicker<Long> materialDatePicker = materialDateBuilder.build();
                materialDatePicker.show(getChildFragmentManager(), "MATERIAL_DATE_PICKER");

                materialDatePicker.addOnPositiveButtonClickListener(
                        new MaterialPickerOnPositiveButtonClickListener<Long>() {
                            @SuppressLint("SetTextI18n")
                            @Override
                            public void onPositiveButtonClick(Long selection) {
                                TimeZone timeZoneUTC = TimeZone.getDefault();
                                int offsetFromUTC = timeZoneUTC.getOffset(new Date().getTime()) * -1;
                                SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
                                Date date = new Date(selection + offsetFromUTC);

                                String f = simpleFormat.format(date);
                                String[] pFecha = f.split("-");
                                tlFechaIns.getEditText().setText(pFecha[2] + "/" + pFecha[1] + "/" + pFecha[0]);
                            }
                        });
            }
        });

        btnAgregarRMD.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                crearRMD();
            }
        });
    }

    public void imprimirTicket(String folio) throws ParseException, IOException {
        context = getContext();
        BluetoothUtils.printPhoto(R.drawable.credigrup_ticket_3);

        RMD rmd = rmdController.getRMDParaImpresion(folio);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            BluetoothUtils.imprimirRMD(rmd);
        }
    }

    public void crearRMD() {
        String folio = edTxtFolio.getText().toString();
        String numeroCuenta = edTxtNumeroCuenta.getText().toString();
        String nombre = edTxtNombre.getText().toString();
        String telefono = edTxtTelefono.getText().toString();
        String ruta = edTxtRuta.getText().toString();
        String poblacion = edTxtPoblacion.getText().toString();
        String fecha = edTxtFecha.getText().toString();

        ArrayList<Articulo> articulos = articulosAgregados;

        String valorGarantia = edTxtValorGarantia.getText().toString();
        String pagara = edTxtPagara.getText().toString();
        String fechaIns = edTxtFechaIns.getText().toString();
        String recibeMercancia = edTxtRecibeMercancia.getText().toString();

        String firmaCliente = this.firmaCliente;
        String firmaAsesor = this.firmaAsesor;

        if (Validator.fieldValidation(tlValorGarantia, "El campo Valor de garantía es requerido")
                && Validator.fieldValidation(tlPagara, "El campo Pagara es requerido")
                && Validator.fieldValidation(tlFechaIns, "El campo Fecha es requerido")
                && Validator.fieldValidation(tlRecibeMercancia, "El campo Recibe Mercancia es requerido")
        ) {
            if (firmaCliente == null || firmaAsesor == null) {
                AlertDialog.Builder builder = new AlertDialog.Builder(requireActivity());
                builder.setTitle("Ambas firmas son requeridas");
                builder.setMessage("Faltan una o ambas firmas de ser dibujadas.");

                builder.setPositiveButton("Aceptar", new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int id) {
                        dialog.dismiss();
                    }
                });

                AlertDialog dialog = builder.create();
                dialog.show();
            }
            if (articulos.isEmpty()) {
                AlertDialog.Builder builder = new AlertDialog.Builder(requireActivity());
                builder.setTitle("Agregar articulos");
                builder.setMessage("Se debe de haber agregado por lo menos un artículo.");

                builder.setPositiveButton("Aceptar", new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int id) {
                        dialog.dismiss();
                    }
                });

                AlertDialog dialog = builder.create();
                dialog.show();
            }
            if (!articulos.isEmpty() && firmaCliente != null && firmaAsesor != null) {
                RMD rmd = new RMD(
                        folio,
                        articulos,
                        valorGarantia,
                        fechaIns,
                        pagara,
                        fecha,
                        firmaCliente,
                        firmaAsesor,
                        recibeMercancia
                );

                rmdController.postRMD(rmd, prestamoID, new RMDController.prerararRMDSCallback() {
                    @Override
                    public void onSuccess(String response) {
                        AlertDialog.Builder builder = new AlertDialog.Builder(getContext());

                        builder.setTitle("RMD creado");
                        builder.setMessage("El RMD se ha creado correctamente.");

                        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();

                        builder.setPositiveButton("Imprimir Ticket", new DialogInterface.OnClickListener() {
                            public void onClick(DialogInterface dialog, int id) {
                                if (mConnectedThread == null || !bluetoothAdapter.isEnabled()) {
                                    mConnectedThread = null;
                                    AlertDialog.Builder builder2 = new AlertDialog.Builder(getContext());

                                    builder2.setTitle("No hay impresora conectada");
                                    builder2.setMessage("¿Desea contectarse a una impresora?");
                                    builder2.setPositiveButton("Conectarse", new DialogInterface.OnClickListener() {
                                        @Override
                                        public void onClick(DialogInterface dialog, int which) {
                                            ProgressDialog progressDialog = new ProgressDialog(getContext());

                                            if (!bluetoothAdapter.isEnabled()) {
                                                Toast.makeText(getContext(), "Enciende el bluetooth para continuar", Toast.LENGTH_SHORT).show();
                                                AlertDialog d = builder2.create();
                                                progressDialog.dismiss();
                                                d.show();
                                            } else {
                                                DashboardActivity da = (DashboardActivity) getActivity();
                                                da.conectarImpresora(new DashboardActivity.ConexionCallback() {
                                                    @Override
                                                    public void onSuccess() {
                                                        progressDialog.dismiss();
                                                        AlertDialog dialog = builder.create();
                                                        dialog.show();
                                                    }
                                                });
                                            }
                                        }
                                    });

                                    builder2.setNegativeButton("Cancelar", new DialogInterface.OnClickListener() {
                                        @Override
                                        public void onClick(DialogInterface dialog, int which) {
                                            dialog.dismiss();
                                            Navigation.findNavController(getActivity(), R.id.nav_host_fragment_content_dashboard).navigate(R.id.nav_rmd);
                                        }
                                    });

                                    builder2.setCancelable(false);
                                    AlertDialog dialog2 = builder2.create();
                                    dialog2.show();
                                } else {
                                    try {
                                        imprimirTicket(folio);
                                        dialog.dismiss();
                                    } catch (ParseException e) {
                                        throw new RuntimeException(e);
                                    } catch (IOException e) {
                                        throw new RuntimeException(e);
                                    }
                                    AlertDialog d = builder.create();
                                    d.show();
                                }
                            }
                        });

                        builder.setNegativeButton("Cerrar", new DialogInterface.OnClickListener() {
                            public void onClick(DialogInterface dialog, int id) {
                                dialog.dismiss();
                                Navigation.findNavController(getActivity(), R.id.nav_host_fragment_content_dashboard).navigate(R.id.nav_rmd);
                            }
                        });

                        builder.setCancelable(false);
                        AlertDialog dialog = builder.create();
                        dialog.show();
                    }

                    @Override
                    public void onError(String error) {
                        Toast.makeText(getContext(), "Error al crear RMD", Toast.LENGTH_SHORT).show();
                        Log.d("Error insercion local", error);
                    }

                    @Override
                    public void onSucess() {

                    }
                });

                if (NetworkChange.isConnectedToInternet(getContext())) {
                    rmdController.subirRMDServidor(rmd, prestamoID);
                }
            }
        }
    }

    public void setArticulosRecyclerView() {
        AgregarArticuloRMDAdapter adapter = new AgregarArticuloRMDAdapter(this, getActivity(), getContext(), articulosAgregados);
        RecyclerView.LayoutManager layoutManager = new LinearLayoutManager(getContext());
        rvArticulos.setLayoutManager(layoutManager);
        rvArticulos.setItemAnimator(new DefaultItemAnimator());
        rvArticulos.setAdapter(adapter);
    }

    private static final int REQUEST_CODE_GALERIA = 100;
    private static final int REQUEST_CODE_CAMARA = 101;

    public int iArt;
    public MostrarImagenesRMDAdapter adapterImagenes;
    public RecyclerView.LayoutManager layoutManagerImagenes;
    public RecyclerView rvImagenes;
    public TextView tvCountFotosImagenes;

    public Uri imgUri;

    public void arbirCamara(int pos, MostrarImagenesRMDAdapter adapter, RecyclerView.LayoutManager layoutManager, RecyclerView rv, TextView tvCountFotos) {
        Intent takePictureIntent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
        this.adapterImagenes = adapter;
        this.layoutManagerImagenes = layoutManager;
        this.rvImagenes = rv;
        this.tvCountFotosImagenes = tvCountFotos;
        iArt = pos;
        if (takePictureIntent.resolveActivity(requireActivity().getPackageManager()) != null) {
            ContentValues values = new ContentValues();

            values.put(MediaStore.Images.Media.TITLE, "Imagen ejemplo");
            values.put(MediaStore.Images.Media.DESCRIPTION, "Camara ejemplo");

            Uri image_uri = getContext().getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
            imgUri = image_uri;
            takePictureIntent.putExtra(MediaStore.EXTRA_OUTPUT, image_uri);

            startActivityForResult(takePictureIntent, REQUEST_CODE_CAMARA);
        }
    }

    public void abrirGaleria(int pos, MostrarImagenesRMDAdapter adapter, RecyclerView.LayoutManager layoutManager, RecyclerView rv, TextView tvCountFotos) {
        this.adapterImagenes = adapter;
        this.layoutManagerImagenes = layoutManager;
        this.rvImagenes = rv;
        this.tvCountFotosImagenes = tvCountFotos;
        Intent intent = new Intent(Intent.ACTION_GET_CONTENT);
        intent.setType("image/*");
        intent.putExtra(Intent.EXTRA_ALLOW_MULTIPLE, true);
        intent.addCategory(Intent.CATEGORY_OPENABLE);
        startActivityForResult(Intent.createChooser(intent, "Selecciona imagenes"), REQUEST_CODE_GALERIA);
        iArt = pos;
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);

        if (requestCode == REQUEST_CODE_CAMARA && resultCode == Activity.RESULT_OK) {
            guardarBitmapDesdeUri(imgUri);
        } else if (requestCode == REQUEST_CODE_GALERIA && resultCode == Activity.RESULT_OK && data != null) {
            int imagenesActuales = articulosAgregados.get(iArt).getImagenes().size();

            if (data.getClipData() != null) {
                int count = data.getClipData().getItemCount();

                if (count + imagenesActuales > 2) {
                    Toast.makeText(getContext(), "Solo puedes agregar un máximo de 2 imágenes", Toast.LENGTH_SHORT).show();
                    return;
                }

                for (int i = 0; i < count; i++) {
                    Uri imageUri = data.getClipData().getItemAt(i).getUri();
                    guardarBitmapDesdeUri(imageUri);
                }
            } else if (data.getData() != null) {
                if (imagenesActuales >= 2) {
                    Toast.makeText(getContext(), "Solo puedes agregar un máximo de 2 imágenes", Toast.LENGTH_SHORT).show();
                    return;
                }
                Uri imageUri = data.getData();
                guardarBitmapDesdeUri(imageUri);
            }
        }
    }

    private void guardarBitmapDesdeUri(Uri uri) {
        try {
            articulosAgregados.get(iArt).getUrisImagenes().add(uri);

            Bitmap original = MediaStore.Images.Media.getBitmap(requireContext().getContentResolver(), uri);
            Bitmap mutableBitmap = original.copy(Bitmap.Config.ARGB_8888, true);

            mutableBitmap = agregarFechaYUbicacionAImagen(mutableBitmap);
            articulosAgregados.get(iArt).getImagenes().add(mutableBitmap);

            rvImagenes.setLayoutManager(layoutManagerImagenes);
            rvImagenes.setAdapter(adapterImagenes);
            tvCountFotosImagenes.setText(articulosAgregados.get(iArt).getImagenes().size() + "/2");
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Bitmap agregarFechaYUbicacionAImagen(Bitmap bitmap) {
        addDateTimeToBitmap(bitmap);
        addCoordsToBitmap(bitmap);
        return bitmap;
    }

    private void addCoordsToBitmap(Bitmap bitmap) {
        getCurrentLocation();

        String text = lat + ", " + lgt;

        Canvas canvas = new Canvas(bitmap);

        Paint backgroundPaint = new Paint();

        Paint textPaint = new Paint();
        textPaint.setColor(Color.WHITE);
        textPaint.setTextSize(100);
        textPaint.setAntiAlias(true);

        float textWidth = textPaint.measureText(text);
        float textHeight = textPaint.getTextSize();

        float padding = 10;

        float x = bitmap.getWidth() - textWidth - padding;
        float y = bitmap.getHeight() - padding;

        canvas.drawRect(
                x - padding,
                y - textHeight - padding / 2,
                bitmap.getWidth(),
                bitmap.getHeight(),
                backgroundPaint
        );

        canvas.drawText(text, x, y, textPaint);
    }

    @SuppressLint("MissingPermission")
    private void getCurrentLocation() {
        LocationManager locationManager = (LocationManager)getActivity().getSystemService(Context.LOCATION_SERVICE);

        client = LocationServices.getFusedLocationProviderClient(getActivity());

        if (locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER) || locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER)) {
            client.getLastLocation().addOnCompleteListener(
                    new OnCompleteListener<Location>() {
                        @Override
                        public void onComplete(@NonNull Task<Location> task) {
                            Location location = task.getResult();

                            if (location != null) {
                                lat = String.valueOf(location.getLatitude());
                                lgt = String.valueOf(location.getLongitude());
                            } else {
                                LocationRequest locationRequest = new LocationRequest()
                                        .setPriority(LocationRequest.PRIORITY_HIGH_ACCURACY)
                                        .setInterval(10000)
                                        .setFastestInterval(1000)
                                        .setNumUpdates(1);

                                LocationCallback locationCallback = new LocationCallback() {
                                    @Override
                                    public void
                                    onLocationResult(
                                            LocationResult
                                                    locationResult)
                                    {
                                        Location location1 = locationResult.getLastLocation();

                                        lat = String.valueOf(location.getLatitude());
                                        lgt = String.valueOf(location.getLongitude());
                                    }
                                };

                                client.requestLocationUpdates(locationRequest, locationCallback, Looper.myLooper());
                            }
                        }
                    });
        } else {
            startActivity(new Intent(
                    Settings.ACTION_LOCATION_SOURCE_SETTINGS)
                    .setFlags(Intent.FLAG_ACTIVITY_NEW_TASK));
        }
    }

    private String getCurrentDateTime() {
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("EEEE dd MMMM yyyy - HH:mm:ss", new Locale("es", "MX"));
        String dateTime = sdf.format(now);
        return dateTime.toUpperCase();
    }

    private void addDateTimeToBitmap(Bitmap bitmap) {
        String currentDateTime = getCurrentDateTime();

        Canvas canvas = new Canvas(bitmap);

        Paint backgroundPaint = new Paint();
        backgroundPaint.setColor(Color.parseColor("#80000000"));
        canvas.drawRect(0, bitmap.getHeight() - 110, bitmap.getWidth(), bitmap.getHeight(), backgroundPaint);

        Paint textPaint = new Paint();
        textPaint.setColor(Color.WHITE);
        textPaint.setTextSize(100);
        textPaint.setAntiAlias(true);

        float x = 10;
        float y = bitmap.getHeight() - 15;

        canvas.drawText(currentDateTime, x, y, textPaint);
    }

    public void eliminarImagen(int n) {
        tvCountFotosImagenes.setText(n + "/2");
    }
}

